### 功能块

#### **（一）FB\_InterpolatorXYZ**
![](https://resource.helplook.net/docker_production/3648ne/article/qgxTJ4Ad/680ef8c9039e9.png)


XYZ 三轴连续插补功能块 **FB\_CTRL\_InterpolatorXYZ&#x20;**&#x5177;有多个输入和输出，具体描述如下。所有控制器的参数均通过结构体传递给功能块。

##### **接口**

**VAR\_INPUT**

| 名称                        | **类型**                               | 初始化   | 描述                 |
| ------------------------- | ------------------------------------ | ----- | ------------------ |
| bEnable                   | BOOL                                 | FALSE | 使能信号，上升沿开始插补       |
| bPause                    | BOOL                                 | FALSE | 暂停信号               |
| stCurrentPoint            | ST\_CartesianCoordinate              |       | 读到的当前位置，作为运动的起始点   |
| fInterpolationCycleTime   | LREAL                                | 0     | 插补周期时间\[s]         |
| pInterpolationXYZParams   | POINTER TO ST\_InterpolatorXYZParams |       | 插补参数               |
| nInterpolationPointNumber | UDINT                                | 0     | 插补点数，最大9个点。第一个点为起点 |

**VAR\_OUTPUT**

| 名称                      | **类型**                     | 初始化   | 描述      |
| ----------------------- | -------------------------- | ----- | ------- |
| bBusy                   | BOOL                       | FALSE | 插补计算中   |
| bDone                   | BOOL                       | FALSE | 插补计算完成  |
| bCommandAborted         | BOOL                       | FALSE | 插补过程终止  |
| bError                  | BOOL                       | FALSE | 出错，错误码  |
| bErrorID                | E\_ZMCError                |       | 统一错误码   |
| nInterpolatorIndex      | UDINT                      |       | 当前插补序号  |
| fActInterpolatorPercent | LREAL                      |       | 当前插补百分比 |
| Profile                 | ST\_InterpolatorXYZProfile |       | 插补输出    |

##### **使用要求**

| 开发环境                | 目标平台     | 需要包含的**PLC 库**   |
| ------------------- | -------- | ---------------- |
| MetaFacture/Codesys | PC or CX | ZKSDInterpolator |

#### （二）结构体定义

##### **ST\_CartesianCoordinate**

| **名称** | **类型** | 初始化 | 描述     |
| ------ | ------ | --- | ------ |
| fX     | LREAL  | 0.0 | \[mm]  |
| fY     | LREAL  | 0.0 | \[mm]  |
| fZ     | LREAL  | 0.0 | \[mm]  |
| fA     | LREAL  | 0.0 | \[deg] |
| fB     | LREAL  | 0.0 | \[deg] |
| fC     | LREAL  | 0.0 | \[deg] |

##### **ST\_InterpolatorXYZParams**

| **名称**             | **类型**                  | 初始化 | 描述                                                                         |
| ------------------ | ----------------------- | --- | -------------------------------------------------------------------------- |
| nPatType           | USINT                   | 0   | 指令类型：1=直线绝对运动；2=三点圆弧（中间点+末端点）；3=XY平面顺圆弧（末端点+半径）；4=XY平面逆圆弧（末端点+半径）；5=直线相对运动 |
| nVelocityType      | USINT                   | 1   | 速度曲线类型：预留参数，未使用                                                            |
| stKinematicsParams | ST\_KinematicsParams    |     | 运动学参数                                                                      |
| stTargetPoint      | ST\_CartesianCoordinate |     | 目标点                                                                        |
| fCirdeArcRadius    | LREAL                   | 0   | 当类型是XY平面顺/逆圆弧                                                              |
| stMiddlePoint      | ST\_CartesianCoordinate |     | 圆弧中间点：预留参数，未使用                                                             |
| nSmoothType        | USINT                   | 1   | 平滑类型：预留参数，未使用                                                              |
| fSmoothRadius      | LREAL                   | 0   | 过渡平滑半径预留参数，未使用                                                             |
| nSmoothAccWay      | USINT                   | 0   | 平滑过渡曲线加速度采用对应指令加速度：预留参数，未使用                                                |

##### **ST\_InterpolatorXYZProfile**

| **名称** | **类型**                         |
| ------ | ------------------------------ |
| X      | ST\_InterpolatorXYZProfileData |
| Y      | ST\_InterpolatorXYZProfileData |
| Z      | ST\_InterpolatorXYZProfileData |

##### **ST\_InterpolatorXYZProfileData**

| **名称**        | **类型** |
| ------------- | ------ |
| fPosition     | LREAL  |
| fVelocity     | LREAL  |
| fAcceleration | LREAL  |
| fJerk         | LREAL  |

#### **（三）FB\_PickBond**
![](https://resource.helplook.net/docker_production/3648ne/article/qgxTJ4Ad/680ef8da2b1ff.png)


避障功能块 **FB\_PickBond&#x20;**&#x5177;有多个输入和输出，具体描述如下。所有控制器的参数均通过结构体传递给功能块。

##### **接口**

**VAR\_INPUT**

| 名称                      | **类型**             | 初始化   | 描述                     |
| ----------------------- | ------------------ | ----- | ---------------------- |
| bEnable                 | BOOL               | FALSE | 使能信号，上升沿开始插补，下降沿所有信息复位 |
| bPause                  | BOOL               | FALSE | 暂停信号                   |
| stPickBondParams        | ST\_PickBondParams |       | PickBond参数             |
| fInterpolationCycleTime | LREAL              | 0     | 插补周期时间\[s]             |

**VAR\_OUTPUT**

| 名称              | **类型**                            | 初始化   | 描述     |
| --------------- | --------------------------------- | ----- | ------ |
| bBusy           | BOOL                              | FALSE | 插补计算中  |
| bDone           | BOOL                              | FALSE | 插补计算完成 |
| bCommandAborted | BOOL                              | FALSE | 插补过程终止 |
| bError          | BOOL                              | FALSE | 出错，错误码 |
| bErrorID        | E\_ZMCError                       |       | 统一错误码  |
| stOverallInfo   | ST\_InterpolatorOverallInfomation |       | 路径段    |
| stProfile       | ST\_InterpolatorXYZABCProfile     |       | 插补输出   |

##### **使用要求**

| 开发环境        | 目标平台 | 需要包含的**PLC 库**   |
| ----------- | ---- | ---------------- |
| MetaFacture | PC   | ZKSDInterpolator |

#### （四）结构体定义

##### **ST\_PickBondParams**

| **名称**              | **类型**                                         | 描述                    |
| ------------------- | ---------------------------------------------- | --------------------- |
| stPickBondEjector   | ST\_PickBondEjector                            | 顶针机构参数                |
| ePickBondProcess    | E\_PickBondPhase                               | PickBond过程            |
| stObstacleCuboid    | ST\_ObstacleCuboid                             | 障碍物坐标                 |
| stCoordinateFrame   | ST\_CoordinatePositionOrientationInGlobalFrame | 原点在全局坐标系中的位置 以及各轴是否反向 |
| stKinematicsParams  | ST\_KinematicsParams                           | 运动学参数                 |
| stPickPoint         | ST\_CartesianCoordinate                        | 起点坐标                  |
| stBondPoint         | ST\_CartesianCoordinate                        | 终点坐标                  |
| fHeightOverObstacle | LREAL                                          | 避障高度                  |
| fSaveMargin         | LREAL                                          | 安全距离                  |

##### **ST\_InterpolatorOverallInfomation**

| **名称**           | **类型**                | 描述         |
| ---------------- | --------------------- | ---------- |
| fDuration        | LREAL                 | \[s]       |
| ePickBondProcess | E\_PickBondPhase      | PickBond过程 |
| eEjectPhase      | E\_PickBondEjectPhase | 顶针运行阶段     |
| eZAxisPhase      | E\_PickBondZAxisPhase | Z轴运行阶段     |

##### **ST\_InterpolatorXYZABCProfile**

| **名称** | **类型**                         |
| ------ | ------------------------------ |
| X      | ST\_InterpolatorXYZProfileData |
| Y      | ST\_InterpolatorXYZProfileData |
| Z      | ST\_InterpolatorXYZProfileData |
| A      | ST\_InterpolatorXYZProfileData |
| B      | ST\_InterpolatorXYZProfileData |
| C      | ST\_InterpolatorXYZProfileData |

##### **ST\_PickBondEjector**

| 名称                    | **类型** | 初始化 | 描述                  |
| --------------------- | ------ | --- | ------------------- |
| fCAMMinPosition       | LREAL  | 0.0 | 顶针凸轮最小位置\[mm]       |
| fCAMMaxPosition       | LREAL  | 0.0 | 顶针凸轮最大位置\[mm]       |
| fCAMMinAngle          | LREAL  | 0.0 | 顶针凸轮最小角度\[deg]      |
| fCAMMaxAngle          | LREAL  | 0.0 | 顶针凸轮最大角度\[deg]      |
| fEjectSpeed           | LREAL  | 0.0 | 顶针运动速度\[mm/s]       |
| fEjectAcceleration    | LREAL  | 0.0 | 顶针运动加速度\[mm/s2]     |
| fEjectDeceleration    | LREAL  | 0.0 | 顶针运动减速度\[mm/s2]     |
| fEjectJerk            | LREAL  | 0.0 | 顶针运动加加速度\[mm/s3]    |
| fBlueMembranePosition | LREAL  | 0.0 | 在顶针坐标系中蓝膜的绝对位置\[mm] |
| fEjectSyncDistance    | LREAL  | 0.0 | 同步顶出距离\[mm]         |

##### **ST\_ObstacleCuboid**

| **名称**           | **类型**                  | 描述     |
| ---------------- | ----------------------- | ------ |
| stNegativeCorner | ST\_CartesianCoordinate | 负向角点坐标 |
| stPositiveCorner | ST\_CartesianCoordinate | 正向角点坐标 |

##### **ST\_CoordinatePositionOrientationInGlobalFrame**

| 名称        | **类型** | 初始化   | 描述                 |
| --------- | ------ | ----- | ------------------ |
| fXOffset  | LREAL  | 0.0   | 坐标系相对机器人坐标系偏移\[mm] |
| fYOffset  | LREAL  | 0.0   | 坐标系相对机器人坐标系偏移\[mm] |
| fZOffset  | LREAL  | 0.0   | 坐标系相对机器人坐标系偏移\[mm] |
| fAOffset  | LREAL  | 0.0   | 坐标系相对机器人坐标系偏移\[mm] |
| fBOffset  | LREAL  | 0.0   | 坐标系相对机器人坐标系偏移\[mm] |
| fCOffset  | LREAL  | 0.0   | 坐标系相对机器人坐标系偏移\[mm] |
| bXReverse | BOOL   | FALSE | TRUE or FALSE      |
| bVReverse | BOOL   | FALSE | TRUE or FALSE      |
| bZReverse | BOOL   | FALSE | TRUE or FALSE      |
| bAReverse | BOOL   | FALSE | TRUE or FALSE      |
| bBReverse | BOOL   | FALSE | TRUE or FALSE      |
| bCReverse | BOOL   | FALSE | TRUE or FALSE      |

##### **ST\_KinematicsParams**

| **名称**                 | **类型**                   | 描述              |
| ---------------------- | ------------------------ | --------------- |
| X                      | ST\_KinematicsParamsAxis | 轴坐标系下运动时使用      |
| Y                      | ST\_KinematicsParamsAxis | 轴坐标系下运动时使用      |
| Z                      | ST\_KinematicsParamsAxis | 轴坐标系下运动时使用      |
| A                      | ST\_KinematicsParamsAxis | 轴坐标系下运动时使用      |
| B                      | ST\_KinematicsParamsAxis | 轴坐标系下运动时使用      |
| C                      | ST\_KinematicsParamsAxis | 轴坐标系下运动时使用      |
| stCartesianTranslation | ST\_KinematicsParamsAxis | 笛卡尔中位置运动时使用     |
| stCartesianRotation    | ST\_KinematicsParamsAxis | 笛卡尔中姿态旋转时使用     |
| eRampType              | E\_ZMCProfileType        | 速度曲线类型：预留参数，未使用 |

##### **ST\_KinematicsParamsAxis**

| 名称            | **类型** | 初始化 | 描述           |
| ------------- | ------ | --- | ------------ |
| fVelocity     | LREAL  | 0   | 速度\[mm/s]    |
| fAcceleration | LREAL  | 0   | 加速度\[mm/s2]  |
| fDeceleration | LREAL  | 0   | 减速度\[mm/s2]  |
| fJerk         | LREAL  | 0   | 加加速度\[mm/s3] |



##### **E\_PickBondPhase**

| 名称             | **类型** | 初始化 | 描述         |
| -------------- | ------ | --- | ---------- |
| PICK\_TO\_BOND | INT    | 1   | 从Pick到Bond |
| BOND\_TO\_PICK | INT    | 2   | 从Bond到Pick |

##### **E\_PickBondEjectPhase**

| 名称                             | **类型** | 初始化 | 描述       |
| ------------------------------ | ------ | --- | -------- |
| MOVE\_TO\_PREEJECT\_POSITION   | INT    | 0   | 运动到预顶针位置 |
| IN\_PREEJECT\_POSITION         | INT    | 1   | 在预顶针位置   |
| MOVE\_TO\_DIE\_BOTTOM\_SURFACE | INT    | 2   | 运动到芯片下表面 |
| IN\_DIE\_BOTTOM\_SURFACE       | INT    | 3   | 在芯片下表面   |
| EJECTOR\_SYNC\_LIFT\_UP        | INT    | 4   | 顶针同步上升   |
| EJECTOR\_DECELERATION          | INT    | 5   | 顶针减速停止   |
| IN\_STOP\_POSITION             | INT    | 6   | 到达减速停止位置 |

##### **E\_PickBondZAxisPhase**

| 名称                            | **类型** | 初始化 | 描述        |
| ----------------------------- | ------ | --- | --------- |
| TO\_PICK\_MAX\_FORCE          | INT    | 1   |           |
| MOVE\_TO\_DIE\_FRONT\_SURFACE | INT    | 2   | 运动到芯片上表面  |
| IN\_DIE\_FRONT\_SURFACE       | INT    | 3   | 在芯片上表面    |
| SYNC\_LIFT\_UP                | INT    | 4   | 和顶针同步提升阶段 |
| TO\_BOND\_MAX\_FORCE          | INT    | 5   |           |
| MOVE\_TO\_BOND\_POSITION      | INT    | 6   | 运动到Bond位置 |
| IN\_BOND\_POSITION            | INT    | 7   | 在Bond位置   |

### 二、示例代码

以下示例代码用于插补器的测试。运行代码后，用户可以通过网页访问可视化界面，在虚拟环境中对轴运动进行测试和验证。